#extension GL_EXT_gpu_shader4 : enable

attribute vec4 position; 
attribute vec2 texcoord; 

uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 tview;
uniform float pSize;
uniform vec3 eyePos; 
uniform float time;

varying vec2 tc; 
varying float dofCoef;
varying float alpha; 
varying vec3 vdir;
varying float fogCoef;
varying float pulse; 
varying float lightCoef; 

float farPlane = 4000.0;
float nearPlane = 1.0;
float exponent = 5.00;
float focalPoint = .025; 
float fogFar = 12000.0;


void main()
{

	lightCoef = 1.0;//20*pow(1.0-length(position.xyz)/farPlane, 20.0); 
	
	vec4 center = vec4(texcoord.xy-vec2(.5), 0.0, 1.0); 
	float size = .75*pSize*(1.0+.5+.5*sin(position.w*20.0+time));
	//size += lightCoef;

	pulse = .5+.5*sin(position.w*20+time*position.w*10.0);
	vec4 bboard = size*(center.x*tview[0]+center.y*tview[1]);
	vec4 newPos = vec4(bboard.xyz+position.xyz, 1.0);
	gl_Position = viewproj*newPos;

	//dof
	vec4 viewpos = view*newPos;
	vdir = normalize(viewpos.xyz-eyePos);
	float dist = clamp(1.0-length(viewpos.xyz-eyePos)/fogFar, 0.0, 1.0);

	float pz = ((-viewpos.z)-nearPlane)/(farPlane-nearPlane); 
	//expz = clamp(pow(abs(pz-focalPoint)*8.0, exponent), 0.0, 1.0);
	dofCoef = clamp(pow(abs(pz-focalPoint)*8.0, exponent), 0.0, 1.0);

	// fix tc
	tc = texcoord;
	tc.y = 1.0-tc.y;

	//alpha = position.w; 
	
	fogCoef = 1.0*dist*dist;
//	fogCoef = 1.0;

}


//FRAGMENT
varying vec2 tc;
varying vec3 vdir; 
varying float fogCoef; 
varying float pulse; 
varying float dofCoef;
varying float lightCoef; 

uniform sampler2D Texture0;   //symbolmap
uniform sampler2D Texture1;   //pre-blurred
uniform samplerCube Texture2;   //screenColor
uniform sampler2D Texture3;  //background
uniform float tracks[64]; 
//17: particle intensity


void main() {

	vec4 sharp = 1.0-texture2D(Texture0, tc, 0);
	vec4 blurred = 1.0-texture2D(Texture1, tc, 0); 

	//sharp.a = 1.0-sharp.r;
	//blurred.a = 1.0-blurred.r;


	vec4 color = pow(textureCube(Texture2, vdir), vec4(1.2));
	float fog_color = texture2D(Texture3, gl_FragCoord.xy/vec2(2560, 1440));

	// first shape
	float alpha = 1.0-sharp.r;//mix(1.0-sharp.r, 1.0-blurred.r, dofCoef); 
	gl_FragColor = color*alpha*1.0;

	gl_FragColor *= (.2+.8*dofCoef);
	gl_FragColor.a *= fogCoef*2.0;

	gl_FragColor *= vec4(tracks[36]);

	gl_FragColor.a *= pulse*5.0;



}

